#ifndef hp605x_h
#define hp605x_h

#include <visatype.h>

#define HP605X_INST_ERROR_DETECT_OFF        0
#define HP605X_INST_ERROR_DETECT_POLL       1
#define HP605X_INST_ERROR_DETECT_INTERRUPT  2
#define HP605X_REG_ESE                      3
#define HP605X_REG_ESR                      4
#define HP605X_REG_SRE                      5
#define HP605X_REG_STB                      6
#define HP605X_REG_STAT_OPER                7
#define HP605X_REG_STAT_OPER_COND           8
#define HP605X_REG_STAT_OPER_ENAB           9
#define HP605X_REG_STAT_OPER_NTR           10
#define HP605X_REG_STAT_OPER_PTR           11
#define HP605X_REG_STAT_QUES               12
#define HP605X_REG_STAT_QUES_COND          13
#define HP605X_REG_STAT_QUES_ENAB          14
#define HP605X_REG_STAT_QUES_NTR           15
#define HP605X_REG_STAT_QUES_PTR           16
#define HP605X_TRIG_BUS                    17
#define HP605X_TRIG_IMMEDIATE              18

#define HP605X_CHAN                 2000 
#define HP605X_CHAN_MAX             2001
#define HP605X_CHAN_MIN             2002
#define HP605X_CURR                 2003
#define HP605X_CURR_MAX             2004
#define HP605X_CURR_MIN             2005
#define HP605X_CURR_SLEW            2006
#define HP605X_CURR_SLEW_MAX        2007
#define HP605X_CURR_SLEW_MIN        2008
#define HP605X_CURR_TLEV            2009
#define HP605X_CURR_TLEV_MAX        2010
#define HP605X_CURR_TLEV_MIN        2011
#define HP605X_CURR_TRIG            2012
#define HP605X_CURR_TRIG_MAX        2013
#define HP605X_CURR_TRIG_MIN        2014
#define HP605X_CURR_RANG            2015
#define HP605X_CURR_RANG_MAX        2016
#define HP605X_CURR_RANG_MIN        2017
#define HP605X_MEAS_CURRENT         2018
#define HP605X_MEAS_POWER           2019
#define HP605X_MEAS_VOLTAGE         2020
#define HP605X_MODE_CURRENT         2021
#define HP605X_MODE_RESISTANCE      2022
#define HP605X_MODE_VOLTAGE         2023
#define HP605X_REG_STAT_CHAN        2024
#define HP605X_REG_STAT_CHAN_COND   2025
#define HP605X_REG_STAT_CHAN_ENAB   2026
#define HP605X_REG_STAT_CSUM        2027
#define HP605X_REG_STAT_CSUM_ENAB   2028
#define HP605X_RES                  2029
#define HP605X_RES_MAX              2030
#define HP605X_RES_MIN              2031
#define HP605X_RES_TLEV             2032
#define HP605X_RES_TLEV_MAX         2033
#define HP605X_RES_TLEV_MIN         2034
#define HP605X_RES_TRIG             2035
#define HP605X_RES_TRIG_MAX         2036
#define HP605X_RES_TRIG_MIN         2037
#define HP605X_RES_RANG             2038
#define HP605X_RES_RANG_MAX         2039
#define HP605X_RES_RANG_MIN         2040
#define HP605X_TRAN_MODE_CONTINUOUS 2041
#define HP605X_TRAN_MODE_PULSE      2042
#define HP605X_TRAN_MODE_TOGGLE     2043
#define HP605X_TRIG_SOUR_BUS        2044
#define HP605X_TRIG_SOUR_EXTERNAL   2045
#define HP605X_TRIG_SOUR_HOLD       2046
#define HP605X_TRIG_SOUR_LINE       2047
#define HP605X_TRIG_SOUR_TIMER      2048
#define HP605X_VOLT                 2049
#define HP605X_VOLT_MAX             2050
#define HP605X_VOLT_MIN             2051
#define HP605X_VOLT_TLEV            2052
#define HP605X_VOLT_TLEV_MAX        2053
#define HP605X_VOLT_TLEV_MIN        2054
#define HP605X_VOLT_TRIG            2055
#define HP605X_VOLT_TRIG_MAX        2056
#define HP605X_VOLT_TRIG_MIN        2057
#define HP605X_VOLT_SLEW            2058
#define HP605X_VOLT_SLEW_MAX        2059
#define HP605X_VOLT_SLEW_MIN        2060

#define HP605X_INST_ERROR_DETECTED      (_VI_ERROR+0x3FFC0D07L)
#define HP605X_INST_ERROR_PARAMETER9    (_VI_ERROR+0x3FFC0D20L)
#define HP605X_INST_ERROR_PARAMETER10   (_VI_ERROR+0x3FFC0D21L)
#define HP605X_INST_ERROR_PARAMETER11   (_VI_ERROR+0x3FFC0D22L)

#ifdef __cplusplus
extern "C" {
#endif

ViStatus _VI_FUNC hp605x_abort(ViSession session);

ViStatus _VI_FUNC hp605x_clearInputProtection(ViSession session);

ViStatus _VI_FUNC hp605x_close(ViSession session);

ViStatus _VI_FUNC hp605x_cmd(ViSession session,
                             ViString command);

ViStatus _VI_FUNC hp605x_cmdInt(ViSession session,
                                ViString command,
                                ViInt32 argument);

ViStatus _VI_FUNC hp605x_cmdInt_Q(ViSession session,
                                  ViString command,
                                  ViPInt32 response);

ViStatus _VI_FUNC hp605x_cmdString_Q(ViSession session,
                                     ViString command,
                                     ViInt32 responseSize,
                                     ViPString response);

ViStatus _VI_FUNC hp605x_configureContinuousTransient(ViSession session,
                                                      ViReal64 dutyCycle,
                                                      ViReal64 frequency,
                                                      ViInt32 mode,
                                                      ViReal64 immediateLevel,
                                                      ViReal64 transientLevel);

ViStatus _VI_FUNC hp605x_configureInput(ViSession session,
                                        ViInt32 mode,
                                        ViReal64 level);

ViStatus _VI_FUNC hp605x_configureParallelLoads(ViSession session,
                                                ViInt32 numChannels,
                                                ViAInt32 channels,
                                                ViReal64 currentSlew,
                                                ViInt32 triggerSource,
                                                ViReal64 triggerTimer,
                                                ViReal64 triggerCurrent,
                                                ViBoolean transientState,
                                                ViInt32 transientMode,
                                                ViReal64 transientPulseWidth,
                                                ViReal64 transientCurrent);

ViStatus _VI_FUNC hp605x_configureTrigger(ViSession session,
                                          ViInt32 triggerSource,
                                          ViInt32 mode,
                                          ViReal64 immediateLevel,
                                          ViReal64 triggerLevel);

ViStatus _VI_FUNC hp605x_configureTriggeredTransient(ViSession session,
                                                     ViInt32 triggerSource,
                                                     ViInt32 transientMode,
                                                     ViReal64 pulseWidth,
                                                     ViInt32 mode,
                                                     ViReal64 immediateLevel,
                                                     ViReal64 transientLevel);

ViStatus _VI_FUNC hp605x_dcl(ViSession session);

ViStatus _VI_FUNC hp605x_doDelay(ViSession session,
                                 ViInt32 milliseconds);

ViStatus _VI_FUNC hp605x_error_message(ViSession session,
                                       ViStatus status,
                                       ViPString message);

ViStatus _VI_FUNC hp605x_error_query(ViSession session,
                                     ViPInt32 errorCode,
                                     ViPString errorMessage);

ViStatus _VI_FUNC hp605x_getChannel(ViSession session,
                                    ViInt32 channelType,
                                    ViPInt32 channel);

ViStatus _VI_FUNC hp605x_getCurrent(ViSession session,
                                    ViInt32 currentType,
                                    ViPReal64 current);

ViStatus _VI_FUNC hp605x_getCurrentRange(ViSession session,
                                         ViInt32 currentRangeType,
                                         ViPReal64 currentRange);

ViStatus _VI_FUNC hp605x_getMeasTimeout(ViSession session,
                                        ViPInt32 measTimeout);

ViStatus _VI_FUNC hp605x_getRegister(ViSession session,
                                     ViInt32 registerType,
                                     ViPInt32 registerValue);

ViStatus _VI_FUNC hp605x_getResistance(ViSession session,
                                       ViInt32 resistanceType,
                                       ViPReal64 resistanceValue);

ViStatus _VI_FUNC hp605x_getResistanceRange(ViSession session,
                                            ViInt32 resistanceRangeType,
                                            ViPReal64 resistanceValue);

ViStatus _VI_FUNC hp605x_getTimeout(ViSession session,
                                    ViPInt32 timeout);

ViStatus _VI_FUNC hp605x_getVoltage(ViSession session,
                                    ViInt32 voltageType,
                                    ViPReal64 voltage);

ViStatus _VI_FUNC hp605x_init(ViRsrc resourceId,
                              ViBoolean idQuery,
                              ViBoolean resetInstrument,
                              ViPSession session);

ViStatus _VI_FUNC hp605x_measure(ViSession session,
                                 ViInt32 measurementType,
                                 ViPReal64 measurement);

ViStatus _VI_FUNC hp605x_recall(ViSession session,
                                ViInt32 location);

ViStatus _VI_FUNC hp605x_reset(ViSession session);

ViStatus _VI_FUNC hp605x_revision_query(ViSession session,
                                        ViPString driverRevision,
                                        ViPString instrumentId);

ViStatus _VI_FUNC hp605x_save(ViSession session,
                              ViInt32 location);

ViStatus _VI_FUNC hp605x_self_test(ViSession session,
                                   ViPInt32 testResult,
                                   ViPString errorMessage);

ViStatus _VI_FUNC hp605x_setChannel(ViSession session,
                                    ViInt32 channel);

ViStatus _VI_FUNC hp605x_setCurrent(ViSession session,
                                    ViInt32 currentType,
                                    ViReal64 current);

ViStatus _VI_FUNC hp605x_setCurrentProtection(ViSession session,
                                              ViBoolean isEnabled,
                                              ViReal64 delay,
                                              ViReal64 currentLimit);

ViStatus _VI_FUNC hp605x_setCurrentRange(ViSession session,
                                         ViInt32 currentRangeType,
                                         ViReal64 currentRange);

ViStatus _VI_FUNC hp605x_setInputShort(ViSession session,
                                       ViBoolean inputShort);

ViStatus _VI_FUNC hp605x_setInputState(ViSession session,
                                       ViBoolean inputState);

ViStatus _VI_FUNC hp605x_setInstrumentErrorDetection(ViSession session,
                                                     ViInt32 errorDetectionMode,
                                                     ViInt32 waitTime);

ViStatus _VI_FUNC hp605x_setMeasTimeout(ViSession session,
                                        ViInt32 measTimeout);

ViStatus _VI_FUNC hp605x_setMode(ViSession session,
                                 ViInt32 mode);

ViStatus _VI_FUNC hp605x_setPort(ViSession session,
                                 ViBoolean port);

ViStatus _VI_FUNC hp605x_setRegister(ViSession session,
                                     ViInt32 registerType,
                                     ViInt32 registerValue);

ViStatus _VI_FUNC hp605x_setResistance(ViSession session,
                                       ViInt32 resistanceType,
                                       ViReal64 resistance);

ViStatus _VI_FUNC hp605x_setResistanceRange(ViSession session,
                                            ViInt32 resistanceRangeType,
                                            ViReal64 resistanceRange);

ViStatus _VI_FUNC hp605x_setTimeout(ViSession session,
                                    ViInt32 timeout);

ViStatus _VI_FUNC hp605x_setTransient(ViSession session,
                                      ViBoolean transientState,
                                      ViInt32 transientMode,
                                      ViReal64 dutyCycleOrPulseWidth,
                                      ViReal64 frequency);

ViStatus _VI_FUNC hp605x_setTrigger(ViSession session,
                                    ViInt32 source,
                                    ViReal64 timer);

ViStatus _VI_FUNC hp605x_setVoltage(ViSession session,
                                    ViInt32 voltageType,
                                    ViReal64 voltage);

ViStatus _VI_FUNC hp605x_trigger(ViSession session,
                                 ViInt32 triggerType);

ViStatus _VI_FUNC hp605x_wait(ViSession session);

#ifdef __cplusplus
};
#endif

#endif
